﻿var browse = {
    numericMaxValue: 2147483647,
    context: $(".v-browse"),
    datatable: null,
    caseFilter: null,
    pageStart: 0,
    pageLength: 0,
    totalRecords: 0,
    selectedVariables: null,
    selectedVariablesArray: null,
    selectedVariablesWithMask: null,
    questionName: null,
    currentIndex: 0,
    verifiedBeforeClose: false,
    stratumId: 0,
    initialize: function () {
        $.when(a4.callServerMethod(a4.getProjectAction("GetBrowsePageConfiguration", "Data"))).then(function (result) {
            browse.selectedVariables = result.selectedQuestions;
            if (browse.selectedVariables != null) {
                browse.selectedVariablesArray = browse.selectedVariables.split(",");
                browse.selectedVariablesWithMask = result.selectedQuestionsWithMask;
            }
            responseValidation.initialize(result);

            $.when(responseValidation.loadSelectedQuestionCodes()).then(function (result) {
                browse.initializePage();
            });
        });

        projectMenu.onAfterRefresh = function () {
            browse.datatable.a4datatable("toggleColumns", ["A4SRespondentId"], projectMenu.project.EnableA4S);
            browse.datatable.a4datatable("toggleColumns", ["IntervCall"], (projectMenu.project.EnableCAPI || projectMenu.project.EnableCATI));
            browse.datatable.a4datatable("toggleColumns", ["NextIntervCall", "Location"], projectMenu.project.EnableCAPI, true);
            browse.refreshContent();
        };
    },
    selectedVariableRecordingColumnIsVisible: function (index)
    {
        if (browse.selectedVariablesArray != null && index < browse.selectedVariablesArray.length) {
            var varName = browse.selectedVariablesArray[index];

            if (browse.selectedVariablesWithMask[varName]) {
                var mask = browse.selectedVariablesWithMask[varName].Mask.toUpperCase();
                return mask.startsWith('$PRONTO') && mask.includes('RECORD') && mask.includes('CREATEID=1');
            }
            else
                return false;
        }
        else
            return false;

    },
    getDataTableColumns: function () {
        var columns = [];

        columns.push({ "Name": "Seed", "Title": resources.Index, "Data": "Seed" });
        columns.push({ "Name": "Id", "Title": resources.CaseId, "Data": "Id", "HideInSelector": true });

        columns.push({ "Name": "A4SRespondentId", "Title": resources.A4SID, "Data": "A4SRespondentId", "Visible": projectMenu.project.EnableA4S, "HideInSelector": !projectMenu.project.EnableA4S });
        columns.push({ "Name": "Pin", "Title": resources.PIN, "Data": "Pin" });

        if (voxco.security.hasFeature("CAN_READ_PII"))
            columns.push({ "Name": "Phone", "Title": resources.Phone, "Data": "Phone" });

        columns.push({ "Name": "CodeResult", "Title": resources.Result, "Data": "CodeResult" });
        columns.push({ "Name": "Blocked", "Title": resources.Blocked, "Data": "Blocked", "Type": "boolean", "ShowIcon": true });
        columns.push({ "Name": "CallBack", "Title": resources.Callback, "Data": "CallBack", "Type": "boolean", "ShowIcon": true });
        columns.push({ "Name": "CallbackDate", "Title": resources.CallBackDate, "Data": "CallbackDate" });
        columns.push({ "Name": "DoNotCall", "Title": resources.DoNotCall, "Data": "DoNotCall", "Type": "boolean", "ShowIcon": true });
        columns.push({ "Name": "Completed", "Title": resources.Completed, "Data": "Completed", "Type": "boolean", "ShowIcon": true });

        columns.push({ "Name": "IntervCall", "Title": resources.Interviewer, "Data": "IntervCall", "Visible": projectMenu.project.EnableCAPI || projectMenu.project.EnableCATI });
        columns.push({ "Name": "NextIntervCall", "Title": resources.NextInterviewer, "Data": "NextIntervCall", "Visible": projectMenu.project.EnableCAPI, "HideInSelector": !projectMenu.project.EnableCAPI });
        columns.push({ "Name": "Location", "Title": resources.Location, "Data": "LocationText", "Type": "enum", "EnumType": "Location", "Visible": projectMenu.project.EnableCAPI, "HideInSelector": !projectMenu.project.EnableCAPI });

        columns.push({ "Name": "IsAnonymized", "Title": resources.Anonymized, "Data": "IsAnonymized", "Type": "boolean", "ShowIcon": true });

        columns.push({ "Name": "Active", "Title": resources.Active, "Data": "Active", "Type": "boolean", "ShowIcon": true });

        columns.push({ "Name": "Variable0", "Title": "Variable0", "Data": "Variable0", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable0RecordingFileInfo", "Title": "Variable0", "Data": "Variable0RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable1", "Title": "Variable1", "Data": "Variable1", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable1RecordingFileInfo", "Title": "Variable1", "Data": "Variable1RecordingFileInfo", "Visible": false,  "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable2", "Title": "Variable2", "Data": "Variable2", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable2RecordingFileInfo", "Title": "Variable2", "Data": "Variable2RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable3", "Title": "Variable3", "Data": "Variable3", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable3RecordingFileInfo", "Title": "Variable3", "Data": "Variable3RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable4", "Title": "Variable4", "Data": "Variable4", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable4RecordingFileInfo", "Title": "Variable4", "Data": "Variable4RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable5", "Title": "Variable5", "Data": "Variable5", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable5RecordingFileInfo", "Title": "Variable5", "Data": "Variable5RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable6", "Title": "Variable6", "Data": "Variable6", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable6RecordingFileInfo", "Title": "Variable6", "Data": "Variable6RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });        

        columns.push({ "Name": "Variable7", "Title": "Variable7", "Data": "Variable7", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable7RecordingFileInfo", "Title": "Variable7", "Data": "Variable7RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable8", "Title": "Variable8", "Data": "Variable8", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable8RecordingFileInfo", "Title": "Variable8", "Data": "Variable8RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        columns.push({ "Name": "Variable9", "Title": "Variable9", "Data": "Variable9", "Visible": false, "HideInSelector": true, "Editable": "![Online] && [Location] == 'Server'" });
        columns.push({ "Name": "Variable9RecordingFileInfo", "Title": "Variable9", "Data": "Variable9RecordingFileInfo", "Visible": false, "Sortable": false, "HideInSelector": true, "Editable": false });

        var isColumnEditable = function (data) { return !data.Online && data.Location == 'Server'; };

        columns.push({ "Name": "Variable0", "Title": "Variable0", "Data": "Variable0", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable1", "Title": "Variable1", "Data": "Variable1", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable2", "Title": "Variable2", "Data": "Variable2", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable3", "Title": "Variable3", "Data": "Variable3", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable4", "Title": "Variable4", "Data": "Variable4", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable5", "Title": "Variable5", "Data": "Variable5", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable6", "Title": "Variable6", "Data": "Variable6", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable7", "Title": "Variable7", "Data": "Variable7", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable8", "Title": "Variable8", "Data": "Variable8", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });
        columns.push({ "Name": "Variable9", "Title": "Variable9", "Data": "Variable9", "Visible": false, "HideInSelector": true, "Editable": isColumnEditable });

        return columns;
    },
    initializeDataTable: function () {
        browse.stratumId = $("#StratumId").val();

        browse.datatable = $(".h-browse-table", browse.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getProjectAction("GetRespondents", "Data"),
            ajaxParams: { "variables": browse.selectedVariables, "stratumId": browse.stratumId },
            defaultSorting: { Column: "Seed", Ascending: true },
            multiEdit: voxco.security.has('DATA_BROWSE_MODIFY'),
            columns: browse.getDataTableColumns(),
            stateKey: "Browse",
            stateSaveSorting: false,
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            allowRowSelection: voxco.security.has('DATA_BROWSE_MODIFY'),
            displayLength: 20,
            error: function (message) { browse.selectVariables("");},
            toolBar: {
                Items: [{ "Action": "selectVariables", "Label": resources.SelectQuestions, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                        { "Action": "activate", "Label": resources.ActivateFilteredCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('USE_SAMPLE_DEACTIVATION') && voxco.security.has('DATA_BROWSE_MODIFY') && browse.caseFilter != null;} },
                        { "Action": "deactivate", "Label": resources.DeactivateFilteredCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('USE_SAMPLE_DEACTIVATION') && voxco.security.has('DATA_BROWSE_MODIFY') && browse.caseFilter != null; } },
                        { "Action": "deleteFiltered", "Label": resources.DeleteFilteredCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.has('CAN_USE_BROWSER_DELETEALL') && browse.caseFilter != null && !data.Completed; } },
                        { "Action": "unflag", "Label": resources.UnflagCompleted, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.has('CAN_USE_BROWSER_UNFLAGCOMPLETEDCASES') && browse.caseFilter != null && browse.getCountCompletedCases() > 0; } },
                        { "Action": "assign", "Label": resources.AssignInterviewer, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.has('USE_CAPI_ASSIGN_SAMPLE') && browse.caseFilter != null; } },
                        { "Action": "preassign", "Label": resources.PreAssignInterviewer, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.has('USE_CAPI_ASSIGN_SAMPLE') && browse.caseFilter != null && projectMenu.project.EnableCAPI; } },
                        { "Action": "upload", "Label": resources.UploadToA4S, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && browse.caseFilter != null && projectMenu.project.EnableA4S && hasA4SActive } },
                        { "Action": "delete", "Label": resources.Delete, "DisplayMode": dataTables.itemDisplayMode.selected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && !data.Completed && !data.Online && data.Location != 'CAPIClient'; } },
                        { "Action": "reset", "Label": resources.Reset, "DisplayMode": dataTables.itemDisplayMode.selected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && !data.Online && data.Location != 'CAPIClient'; } },
                        { "Action": "addDNC", "Label": resources.AddDNC, "DisplayMode": dataTables.itemDisplayMode.selected, "DisplayCondition": function (data) { return projectMenu.project.EnableCATI && voxco.security.hasFeature('CAN_READ_PII'); } },
                        { "Action": "resetLocation", "Label": resources.ResetLocation, "DisplayMode": dataTables.itemDisplayMode.selected, "DisplayCondition": function (data) { return voxco.security.has('USE_RESP_LOCALISATION') && projectMenu.project.EnableCAPI && data.Location == 'CAPIClient'; } },
                        { "Action": "backToServer", "Label": resources.BringBackToServer, "DisplayMode": dataTables.itemDisplayMode.selected, "DisplayCondition": function (data) { return voxco.security.has('USE_RESP_LOCALISATION') && projectMenu.project.EnableCAPI && data.Location == 'CAPIClient'; } },
                        { "Action": "anonymizeFiltered", "Label": resources.AnonymizeCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.hasFeature('CAN_READ_PII') && data.Location != 'CAPIClient'; } },
                        { "Action": "anonymize", "Label": resources.AnonymizeSelectedCases, "DisplayMode": dataTables.itemDisplayMode.selected, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.hasFeature('CAN_READ_PII') && data.Location != 'CAPIClient'; } }
                ]
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var caseIds = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "selectVariables":
                        browse.showQuestionsSelector();
                        break;
                    case "activate":
                        browse.showActivateDialog(true);
                        break;
                    case "deactivate":
                        browse.showActivateDialog(false);
                        break;
                    case "unflag":
                        browse.tableFilterActionConfirmation(confirmUnflagCasesResources, "UnflagRespondents", browse.getCountCompletedCases());
                        break;
                    case "deleteFiltered":
                        browse.tableFilterActionDelete(confirmDeleteFilteredCasesResources, "DeleteFilteredRespondents", browse.totalRecords);
                        break;
                    case "assign":
                        browse.showAssignDialog(true, confirmUnflagCasesResources);
                        break;
                    case "preassign":
                        browse.showAssignDialog(false, confirmUnflagCasesResources);
                        break;
                    case "upload":
                        browse.showUploadDialog();
                        break;
                    case "delete":
                        browse.tableActionDelete(caseIds, confirmDeleteCasesResources, "DeleteRespondents");
                        break;
                    case "reset":
                        browse.tableActionConfirmation(caseIds, confirmResetCasesResources, "ResetRespondents");
                        break;
                    case "addDNC":
                        browse.tableActionConfirmation(caseIds, confirmDNCCasesResources, "DNCRespondents");
                        break;
                    case "resetLocation":
                        browse.tableActionConfirmation(caseIds, confirmResetLocationResources, "ResetLocationRespondents", 300);
                        break;
                    case "backToServer":
                        browse.tableActionConfirmation(caseIds, confirmBackToServerResources, "BringToServerRespondents");
                        break;
                    case "anonymize":
                        browse.tableActionConfirmation(caseIds, confirmAnonymizeResources, "AnonymizeRespondents", 300);
                        break;
                    case "anonymizeFiltered":
                        browse.tableFilterActionConfirmation(confirmAnonymizeResources, "AnonymizeFilteredRespondents", browse.totalRecords, 300);
                        break;
                }
            },
            contextMenuItems: [
                { "Action": "responses", "Label": resources.EditResponses },
                { "Action": "historic", "Label": resources.ViewHistory },
                { "Action": "details", "Label": resources.EditDetails },
                { "Action": "notes", "Label": resources.ViewNotes },
                { "Action": "logs", "Label": resources.ViewLogs },
                { "Divider": true },
                { "Action": "anonymize", "Label": resources.AnonymizeCase, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.hasFeature('CAN_READ_PII') && data.Location != 'CAPIClient'; } },
                { "Action": "delete", "Label": resources.DeleteCase, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && !data.Completed && !data.Online && data.Location != 'CAPIClient'; } },
                { "Action": "reset", "Label": resources.ResetCase, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && !data.Online && data.Location != 'CAPIClient'; } },
                { "Action": "resetLocation", "Label": resources.ResetLocation, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.has('USE_RESP_LOCALISATION') && projectMenu.project.EnableCAPI && data.Location == 'CAPIClient'; } },
                { "Action": "backToServer", "Label": resources.BringBackToServer, "DisplayCondition": function (data) { return voxco.security.has('DATA_BROWSE_MODIFY') && voxco.security.has('USE_RESP_LOCALISATION') && projectMenu.project.EnableCAPI && data.Location == 'CAPIClient'; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                browse.currentIndex = data.index;
                browse.verifiedBeforeClose = false;

                var data = {
                    respondentId: row.Id,                     
                    rowIndex: browse.currentIndex + 1
                };

                
                // before close function
                var beforeClose = function () {
                    var cb = function () {
                        modalDialog.close();
                        setTimeout(function () { browse.verifiedBeforeClose = false; }, 500);
                    }

                    if (!browse.verifiedBeforeClose && a4.getIFrameTop().respondent.checkUnsavedChanges(cb)) {
                        return false;
                    }
                };

                // After close function
                var afterClose = function () {
                    browse.refreshContent();
                };

                switch (action) {
                    case "responses":
                        data.tab = 1;
                        modalDialog.showWindow(a4.getProjectAction("Respondent", "Data", data), '90%', '90%', {
                            beforeClose: beforeClose,
                            afterClose: afterClose
                        });
                        break;
                    case "historic":
                        data.tab = 2;
                        modalDialog.showWindow(a4.getProjectAction("Respondent", "Data", data), '80%', '70%', {
                            beforeClose: beforeClose,
                            afterClose: afterClose
                        });
                        break;
                    case "details":
                        data.tab = 3;
                        modalDialog.showWindow(a4.getProjectAction("Respondent", "Data", data), '80%', '70%', {
                            beforeClose: beforeClose,
                            afterClose: afterClose
                        });
                        break;
                    case "notes":
                        data.tab = 4;
                        modalDialog.showWindow(a4.getProjectAction("Respondent", "Data", data), '80%', '70%', {
                            beforeClose: beforeClose,
                            afterClose: afterClose
                        });
                        break;
                    case "logs":
                        data.tab = 5;
                        modalDialog.showWindow(a4.getProjectAction("Respondent", "Data", data), '80%', '70%', {
                            beforeClose: beforeClose,
                            afterClose: afterClose
                        });
                        break;
                    case "delete":
                        browse.tableActionDelete([row.Id], confirmDeleteCasesResources, "DeleteRespondents");
                        break;
                    case "reset":
                        browse.tableActionConfirmation([row.Id], confirmResetCasesResources, "ResetRespondents");
                        break;
                    case "resetLocation":
                        browse.tableActionConfirmation([row.Id], confirmResetLocationResources, "ResetLocationRespondents", 300);
                        break;
                    case "backToServer":
                        browse.tableActionConfirmation([row.Id], confirmBackToServerResources, "BringToServerRespondents");
                        break;
                    case "anonymize":
                        browse.tableActionConfirmation([row.Id], confirmAnonymizeResources, "AnonymizeRespondents", 300);
                        break;
                }
            },
            draw: function () {                
                browse.currentIndex = $(this).a4datatable("getPageStart");
                browse.pageLength = $(this).a4datatable("getPageLength");
                browse.totalRecords = $(this).a4datatable("getTotalRecords");
            },
            ready: function () {
                browse.toggleVariableColumns();
            },
            rowBeforeCreated: function (event, data) {
                if (data.data.Location == "CAPIClient" || data.data.Online)
                    $(data.row).addClass("disabled");
            },
            cellCreated: function (evt, data) {
                responseValidation.verifyRowData(data.flagError, data.row, data.rowIndex, data.fieldName, true);

                if (data.fieldName.endsWith("RecordingFileInfo")) {                    
                    
                    if (data.data) {
                        var recordingUrl = a4.getProjectAction("GetAudioRecordingFile", "Data") + "/?file=" + encodeURIComponent(data.data);
                        $(data.cell).html('<audio controls  class="audio-playback" preload="none">  <source src="' + recordingUrl+'" type="audio/wav">  </audio>  ');
                    }
                    
                }
                    
            },
            rowUpdated: function (event, data) {
                responseValidation.verifyRowData(data.flagError, data.data, data.index, data.fieldName, true, null, true);
                
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getProjectAction("UpdateRespondentAnswers", "Data"), {
                    respondents: data.rows
                }, function () {
                    data.multiEditSaveCallback();
                });
            },
            localizableTexts: { "Search": resources.SearchBrowse }
        });

        if ($("#StratumId").val() != "0") {
            caseFilter.getCaseFilter(function (filter, summary) {
                $(".v-caseFilterSummary", browse.context).html(summary);

                if (filter.IsValid) {
                    $(".v-createFilterMessage", browse.context).hide();
                    $(".buttons", browse.context).show();
                    browse.caseFilter = filter;
                    browse.datatable.a4datatable("option", "ajaxParams", { "caseFilter": filter, "stratumId": 0 });
                    browse.datatable.a4datatable("refresh", true, true);
                }
            });
        }
    },
    initializePage: function () {
        var stratumId = $("#StratumId").val();
        if (stratumId == "0") {
            caseFilter.clearCaseFilter();
            caseFilter.initializeCaseFilterAutoComplete();
            browse.caseFilter = null;
        }
        browse.initializeDataTable();
    },
    getCurrentPageIndex: function () {
        return (browse.currentIndex % browse.pageLength);
    },
    getCountCompletedCases: function () {
        return browse.datatable ? browse.datatable.a4datatable("getRowsData").filter(function (x) { return x.Completed; }).length : 0;
    },
    refreshContent: function () {
        $(".h-replaceCodes", browse.context).toggleClass("hidden", !voxco.security.has('DATA_BROWSE_MODIFY') || !voxco.security.has('FINDREPL_BROWSER') || projectMenu.project.IsInterviewerActive);
        $(".h-validateSample, .h-recompute, .h-sort, .h-reset", browse.context).toggleClass("hidden", !voxco.security.has('USE_DATAPROCESSING') || projectMenu.project.IsInterviewerActive);

        browse.datatable.a4datatable("refresh");
    },
    showQuestionsSelector: function () {
        modalDialog.showWindow(a4.getProjectAction("BrowseQuestionsSelector", "Data"), 620, 950, {
            beforeClose: function (data) {
                var questionSelector = $('.fancybox-iframe').contents();
                var confirmed = questionSelector.find(".v-confirmed").val();

                if (confirmed)
                    browse.selectVariables($('.v-selectedQuestions', questionSelector).val());
            }
        });
    },
    selectVariables: function (variables) {
        browse.selectedVariables = variables;

        a4.callServerMethod(a4.getProjectAction("UpdateBrowsePageConfiguration", "Data"), { config: variables }, function (result) {
            if (result.selectedQuestions != null && result.selectedQuestions != "") {
                browse.selectedVariablesArray = result.selectedQuestions.split(",");
                browse.selectedVariablesWithMask = result.selectedQuestionsWithMask;
            }
            else {
                browse.selectedVariablesArray = null;
                browse.selectedVariablesWithMask = null;
            }
            responseValidation.initialize(result);
            responseValidation.loadSelectedQuestionCodes();

            browse.toggleVariableColumns();
            browse.datatable.a4datatable("option", "ajaxParams", { "variables": variables });
            browse.datatable.a4datatable("refresh", true);
        });
    },
    toggleVariableColumns: function () {
        var varArray = [];

        if (browse.selectedVariables)
            varArray = browse.selectedVariables.split(",");

        for (var index = 0; index < 10; index++) {
            var columnName = "Variable" + index;
            var showColumn = varArray[index] != undefined;
                        
            browse.datatable.a4datatable("toggleColumn", columnName, showColumn);
            browse.datatable.a4datatable("changeColumnTitle", columnName, varArray[index]);

            var recordingColumnName = columnName + 'RecordingFileInfo';

            if (browse.selectedVariableRecordingColumnIsVisible(index)) {
                browse.datatable.a4datatable("toggleColumn", recordingColumnName, showColumn);
                browse.datatable.a4datatable("changeColumnTitle", recordingColumnName, varArray[index] + " " + resources.Recording);
            }
            else
                browse.datatable.a4datatable("toggleColumn", recordingColumnName, false);
        }
    },
    toggleCaseFilter: function (sectionBox) {
        sectionBox.find(".section-header .fa").toggleClass("fa-caret-down fa-caret-right");
        $(".section-content", sectionBox).toggle();

        if ($(".section-content", sectionBox).is(":visible") || browse.caseFilter) {
            $(".v-createFilterMessage", sectionBox).hide();
            $(".buttons", sectionBox).show();
        }
        else {
            $(".v-createFilterMessage", sectionBox).show();
            $(".buttons", sectionBox).hide();
        }

        //To trigger datatable adjust height
        $(window).trigger("resize");
    },
    tableActionConfirmation: function (caseIds, resources, action, height) {
        var count = caseIds.length;

        modalDialog.showConfirmDialog(resources, function () {
            a4.callServerMethod(a4.getProjectAction(action, "Data"), {
                respondentIds: caseIds
            },
            function (result) {
                browse.refreshContent();
            });
        }, height, 500, true, {
            "count": count
        });
    },
    tableActionDelete: function (caseIds, resources, action) {

        modalDialog.showConfirmDelete(resources, function () {
            a4.callServerMethod(a4.getProjectAction(action, "Data"), {
                respondentIds: caseIds
            },
            function (result) {
                browse.refreshContent();
            });
        }, caseIds.length);
    },
    tableFilterActionConfirmation: function (resources, action, count, height) {
        modalDialog.showConfirmDialog(resources, function () {
            a4.callServerMethod(a4.getProjectAction(action, "Data"), {
                caseFilter: browse.caseFilter
            },
            function (result) {
                browse.refreshContent();
            });
        }, height, 500, true, {
            "count": count
        });
    },
    tableFilterActionDelete: function (resources, action, count) {
        modalDialog.showConfirmDelete(resources, function () {
            a4.callServerMethod(a4.getProjectAction(action, "Data"), {
                caseFilter: browse.caseFilter
            },
            function (result) {
                browse.refreshContent();
            });
        }, count);
    },
    showActivateDialog: function (isActivate) {
        var method = isActivate ? "ActivateRespondents" : "DeactivateRespondents";
        var activateContainer = $("#activateContainer").clone();
        var container = $('<div id="ActivatePanel" class="flex-container">').append(activateContainer.html());
        var assignCount = 0;
        var type = "All";

        var initContentFunction = function () {
            var editor = $("#ActivatePanel");
            $(".integer", editor).autoNumeric({ aPad: false, vMin: '1', vMax: browse.numericMaxValue, mDec: '0', aSep: '' });

            $("input[type='text']", editor).on("keydown", function () {
                $(this).prev().click();
            });

            $("input[type=radio]", editor).on("click", function () {
                $("input[type=text]", editor).removeClass("selected");
                $(this).next("input[type=text]").addClass("selected");

                $("input[type=text]:not(.selected)", editor).val("");
            });
        }

        var validateContentFunction = function () {
            var editor = $("#ActivatePanel");
            type = $('input[name=filterType]:checked', editor).val();
            var valid = true;

            if (type == "First") {
                assignCount = $('.firstFiltered', editor).val();

                if (!assignCount) {
                    a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $('.firstFiltered', editor).attr("data-text")));
                    valid = false;
                }
            }
            else if (type == "Random") {
                assignCount = $('.randomFiltered', editor).val();

                if (!assignCount) {
                    a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $('.randomFiltered', editor).attr("data-text")));
                    valid = false;
                }
            }

            return valid;
        }

        var activateResources = {
            "Title": isActivate ? resources.ActivateCases : resources.DeactivateCases,
            "Message": container
        };

        modalDialog.showConfirmDialog(activateResources, function () {
            var tableParams = browse.datatable.a4datatable("getTableParams");
            var editor = $("#ActivatePanel");

            var params = {
                numberOfCases: assignCount,
                selection: type,
                caseFilter: browse.caseFilter,
                sortColumn: tableParams.SortColumn,
                sortAscending: tableParams.SortAscending,
                selectedVariables: browse.selectedVariables
            };

            a4.callServerMethod(a4.getProjectAction(method, "Data"), params,
            function (result) {
                browse.refreshContent();
            });
        }, 350, 600, false, null, {
            initFunction: initContentFunction, validateFunction: validateContentFunction
        });
    },
    showAssignDialog: function (isAssign) {
        var method = isAssign ? "AssignRespondents" : "PreAssignRespondents";
        var assignContainer = $("#assignContainer").clone();
        var container = $('<div id="AssignPanel" class="flex-container">').append(assignContainer.html());
        var assignCount = 0;
        var type = "All";
        var requiresAgent = true;

        var initContentFunction = function () {
            var editor = $("#AssignPanel");
            $('input[name=assignType]:first', editor).click();
            $(".v-agentSection", editor).show();
            $(".integer", editor).autoNumeric({ aPad: false, vMin: '1', vMax: browse.numericMaxValue, mDec: '0', aSep: '' });

            $(".v-agentList", editor).a4autocomplete({
                ajaxAction: a4.getProjectAction("GetInterviewersForAutocomplete", "Home"),
                valueProperty: "Id",
                labelProperty: "DisplayName",
                placeHolder: resources.Select
            });

            $("input[type='text']", editor).on("keydown", function () {
                $(this).prev().click();
            });

            $("input[name=assignType]", editor).on("click", function () {
                var val = $(this).val();
                $(".v-agentSection", editor).toggle(val == "Assign");
            });

            $("input[type=radio]", editor).on("click", function () {
                $("input[type=text]", editor).removeClass("selected");
                $(this).next("input[type=text]").addClass("selected");

                $("input[type=text]:not(.selected)", editor).val("");
            });
        }

        var validateContentFunction = function () {
            var editor = $("#AssignPanel");
            type = $('input[name=filterType]:checked', editor).val();
            requiresAgent = $('input[name=assignType]:checked', editor).val() == "Assign";
            var valid = true;

            if ($(".v-agentList", editor).val() == "" && requiresAgent) {
                a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $("#agentLabel").text()));
                valid = false;
            }
            else if (type == "First") {
                assignCount = $('.firstFiltered', editor).val();

                if (!assignCount) {
                    a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $('.firstFiltered', editor).attr("data-text")));
                    valid = false;
                }
            }
            else if (type == "Random") {
                assignCount = $('.randomFiltered', editor).val();

                if (!assignCount) {
                    a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $('.randomFiltered', editor).attr("data-text")));
                    valid = false;
                }
            }

            return valid;
        }

        var assignResources = {
            "Title": isAssign ? resources.AssignInterviewer : resources.PreAssignInterviewer,
            "Message": container
        };

        modalDialog.showConfirmDialog(assignResources, function () {
            var tableParams = browse.datatable.a4datatable("getTableParams");
            var editor = $("#AssignPanel");

            var params = {
                agentId: (requiresAgent ? $(".v-agentList", editor).attr("data-value") : -1),
                numberOfCases: assignCount,
                selection: type,
                caseFilter: browse.caseFilter,
                sortColumn: tableParams.SortColumn,
                sortAscending: tableParams.SortAscending,
                selectedVariables: browse.selectedVariables
            }

            a4.callServerMethod(a4.getProjectAction(method, "Data"), params,
            function (result) {
                browse.refreshContent();
            });
        }, 370, 600, false, null, {
            initFunction: initContentFunction, validateFunction: validateContentFunction
        });
    },
    showUploadDialog: function () {
        var count = browse.totalRecords;
        var uploadContainer = $("#uploadToA4S").clone();
        var container = $('<div id="UploadPanel" class="flex-container">').append(uploadContainer.html());
        var autoDelete;

        var initContentFunction = function () {
            var editor = $("#UploadPanel");
            var dl = $(".v-nbDaysLabel", editor);
            dl.text(dl.attr("data-label").replace('{0}', count));

            $(".v-nbDays", editor).autoNumeric({ aPad: false, vMin: '1', vMax: browse.numericMaxValue, mDec: '0', aSep: '' });

            $(".v-autoDeleteDays", editor).on("click", function () {
                var checked = $(this).is(":checked")
                $(".v-nbDays", editor).attr("disabled", !checked);
            });
        }

        var validateContentFunction = function () {
            var editor = $("#UploadPanel");
            var valid = true;
            autoDelete = $(".v-autoDeleteDays", editor).is(":checked");

            if (autoDelete && $(".v-nbDays", editor).val() == "") {
                a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $("#nbDaysLabel").text()));
                valid = false;
            }

            return valid;
        }

        var uploadResources = {
            "Title": confirmUploadCasesResources.Title,
            "Message": container
        };

        modalDialog.showConfirmDialog(uploadResources, function () {
            var nbDays = (!autoDelete) ? 0 : $("#UploadPanel .v-nbDays").val();

            a4.callServerMethod(a4.getProjectAction("UploadRespondentsToA4S", "Data"), {
                nbDays: nbDays, caseFilter: browse.caseFilter
            },
                function (result) {
                    a4.showSuccessMessage(result.message);
                });
        }, 300, 600, false, null, {
            initFunction: initContentFunction, validateFunction: validateContentFunction
        });
    },
    exportExcel: function (projectId, getFileMethod) {
        var columns = browse.datatable.a4datatable("getVisibleColumns");
        var tableParams = browse.datatable.a4datatable("getTableParams");

        var params = {
            projectId: projectId,
            tableParams: JSON.stringify(tableParams),
            caseFilter: (browse.caseFilter) ? browse.caseFilter : "",
            columns: columns.join(),
            variables: browse.selectedVariables
        };

        a4.showBusyBox();

        a4.callServerMethod(a4.getProjectAction("ExportBrowse", "Data"), params, function (result) {
            a4.hideBusyBox();

            window.location = a4.getProjectAction(getFileMethod, "Data", { filePath: result, fileName: "Browse.xlsx" });
        });
    },
    bindEvents: function () {
        var projectId = $("#ProjectId").val();

        browse.context.on("click", ".h-replaceCodes", function () {
            modalDialog.showWindow(a4.getProjectAction("FindRecode", "Data", "Project", {}), 650, 900, {
                afterClose: function () {
                    browse.refreshContent();
                }
            });
        });

        //browse.context.on("click", ".audioplayback", function () {
        //    alert('1');           
        //});


        browse.context.on("click", ".h-addCodes", function () {
            modalDialog.showWindow(a4.getProjectAction("AddCodeToQuestion", "Data", "Project", {
                questionName: browse.questionName, codeWidth: browse.questionCodeWidth
            }), 500, 700);
        });

        browse.context.on("click", ".h-caseListing", function () {
            var numberCases = browse.datatable.a4datatable("getTotalRecords");
            modalDialog.showWindow(a4.getProjectAction("CaseListings", "Data", { numberCases: numberCases }), 560, 600, {
                afterClose: function () {
                    browse.refreshContent();
                }
            });
        });

        browse.context.on("click", ".h-export", function () {
            browse.exportExcel(projectId, "GetBrowseFile");
        });

        browse.context.on("click", ".section-header, .v-createFilterMessage", function () {
            var sectionBox = $(this).closest(".section-box");
            browse.toggleCaseFilter(sectionBox);
        });

        browse.context.on("click", ".h-applyFilter", function () {
            caseFilter.getCaseFilter(function (filter, summary) {
                $(".v-caseFilterSummary", browse.context).html(summary);
                                
                if (filter.IsValid) {
                    browse.caseFilter = filter;
                    browse.datatable.a4datatable("option", "ajaxParams", { "caseFilter": filter, "stratumId": 0 });
                    browse.datatable.a4datatable("refresh", true, true);
                }
            });
        });

        browse.context.on("click", ".h-clearFilter", function () {
            caseFilter.clearCaseFilter();
            caseFilter.initializeCaseFilterAutoComplete();
            $(".v-caseFilterSummary", browse.context).html("");

            if (browse.caseFilter) {
                browse.caseFilter = null;
                browse.datatable.a4datatable("option", "ajaxParams", { "caseFilter": null });
                browse.datatable.a4datatable("refresh", true, true);

                var sectionBox = $(this).closest(".section-box");

                if (!$(".section-content", sectionBox).is(":visible")) {
                    $(".v-createFilterMessage", sectionBox).show();
                    $(".buttons", sectionBox).hide();
                }
            }
        });

        browse.context.on("click", ".h-validateSample", function () {
            modalDialog.showConfirmDialog(confirmValidateSampleResources, function () {
                a4.callServerMethod(a4.getProjectAction("ValidateDNCSamples", "Data"), {
                    projectId: projectId
                },
                function (result) {
                    a4.showSuccessMessage(result.message);
                    browse.refreshContent();
                });
            }, 250, 500, true);
        });

        browse.context.on("click", ".h-recompute", function () {
            modalDialog.showConfirmDialog(confirmRecomputeTimeZones, function () {
                a4.callServerMethod(a4.getProjectAction("RecomputeTimeZones", "Data"), {
                    projectId: projectId
                },
                    function (result) {
                        a4.showSuccessMessage(result.message);
                    });
            }, 250, 500, true);
        });

        browse.context.on("click", ".h-reset", function () {
            modalDialog.showConfirmDialog(confirmResetProjectDataResources, function () {
                a4.callServerMethod(a4.getProjectAction("ResetProjectData", "Data"), {
                    projectId: projectId
                },
                function (result) {
                    a4.showSuccessMessage(result.message);
                    browse.refreshContent();
                });
            }, 250, 500, true);
        });

    }
};

$(document).ready(function () {
    if (browse.context.length > 0) {

        $(projectMenu).ready(function () {
            browse.initialize();
        });
        
        browse.bindEvents();
    }
});